local DustRedOverLife = {{0.0, 0.99}}
local DustGreenOverLife = {{0.0, 0.98}}
local DustBlueOverLife = {{0.0, 0.86}}

Emitters = {
	[1] = 
	{
        Name = "TracksDirt",
		Texture = "DustDirt.png",
        Technique = "Translucent",
		Flags = {"LocalSpace"},
		InitPositionBox = {Min = {0.0, 0.7, -0.1}, Max = {0.0,0.7, 0.1}},
		
        Number = {{0, 10}},
        Life = {{0.0, 0.25}, {1.0, 0.4}},
        Spin = {{0, -2.0}, {1, 0.0}},
		ShaderParams = {{0, {1,1,0,0}, {1,1,0,0}}},

		ParentVelocity = {{0, 0.95}},
		Velocity = {{0, {0.15, -0.17, -0.01}, {0.20, -0.1, 0.01}}},
		Acceleration = {{0.0, {0.0, -9.8, 0.0}, {0.0, -9.8, 0.0}}},
		
        Size = {{0.0, 0.3}, {1.0, 0.4}},
        SizeOverLife = {{0.0, 0.2}, {0.6, 1.0}},
		
		Windage = {{0, 0.0}},
				
		RedOverLife = {{0.0, 0.204}},
		GreenOverLife = {{0.0, 0.15}},
		BlueOverLife = {{0.0, 0.055}},
        AlfaOverLife = {{0.0, 0}, {0.2, 0}, {0.3, 1}, {0.8, 0.8}, {1.0, 0.2}},
    },
	[2] = 
	{
        Name = "TracksDust",
		Texture = "LitDust.png",
        Technique = "Translucent",
		Flags = {"SoftParticles", "LocalSpace", "Sort"},
		InitPositionBox = {Min = {-1.0, 0.3, -0.25}, Max = {0.0, 0.7, 0.25}},
		
        Number = {{0, 14}},
        Life = {{0.0, 10}, {1.0, 16}},
        Spin = {{0, 0.1}, {0.1, 0.3}, {0.3, -0.1}, {1, 0.01}},
		ShaderParams = {{0, {2,2,0,0}, {2,2,0,0}}},

		ParentVelocity = {{0, 0.4}},
		Velocity = {{0.0, {-0.1, 0.28, 0.1}, {-0.1, 0.48, -0.1}}},
        VelocityOverLife = {{0.0, 0}},
		
        Size = {{0, 2}, {1.0, 2.9}},
        SizeOverLife = {{0, 0.25}, {0.03, 0.43}, {0.06, 1.5}, {0.15, 0.9}, {0.21, 3.12}, {0.35, 2.3}, {1, 1.5}},
		
		Windage = {{0, 0.5}},
				
        RedOverLife = DustRedOverLife,
		GreenOverLife = DustGreenOverLife,
		BlueOverLife = DustBlueOverLife,
        AlfaOverLife = {{0, 0}, {0.01, 0.32}, {0.2, 0.06}, {0.5, 0.02}, {0.99, 0.01}, {1, 0.0}},
    },
}

Lods = 
{
	[1] = 
	{
		Distance = 500,
		Emitters = 
		{
			["TracksDust"] = 
			{
				Number = {{0,10}},
			},
		}
	},
	[2] = 
	{
		Distance = 1000,
		Emitters = 
		{
			["TracksDirt"] = 
			{
				Flags = {'Disable'},
			},
			["TracksDust"] = 
			{
				Number = {{0,8}},
			},
		}
	},
	[3] = 
	{
		Distance = 30000,
		Emitters = 
		{
			["TracksDirt"] = 
			{
				Flags = {'Disable'},
			},
			["TracksDust"] = 
			{
				Flags = {'Disable'},
			},
		}
	},
}